#version 330
#extension GL_EXT_gpu_shader4 : enable
// Dark Heart TreeMod01.fsh  by   zovox
//https://www.shadertoy.com/view/WtK3W3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
//-----------------CONSTANTS MACROS-----------------
#define PI 3.14159265359
#define E 2.7182818284
#define GR 1.61803398875
#define MAX_DIM (max(iResolution.x,iResolution.y))
//--------------------------------------------------

#define time ((sin(float(__LINE__))/PI/GR+1.0)*iTime/PI)
#define flux(x) (vec3(cos(x),cos(4.0*PI/3.0+x),cos(2.0*PI/3.0+x))*.5+.5)

float saw(float x)
{
    float f = mod(floor(abs(x)), 2.0);
    float m = mod(abs(x), 1.0);
    return f*(1.0-m)+(1.0-f)*m;
}

vec2 saw(vec2 x) { return vec2(saw(x.x), saw(x.y)); }
vec3 saw(vec3 x) { return vec3(saw(x.x), saw(x.y), saw(x.z)); }
vec4 saw(vec4 x) { return vec4(saw(x.x), saw(x.y), saw(x.z), saw(x.w)); }


mat2 rotate(float x) { return mat2(cos(x), sin(x), sin(x), -cos(x)); }

float cross2d( in vec2 a, in vec2 b ) { return a.x*b.y - a.y*b.x; }

vec2 invBilinear( in vec2 p, in vec2 a, in vec2 b, in vec2 c, in vec2 d )
{
    vec2 res = vec2(-1.0);

    vec2 e = b-a;
    vec2 f = d-a;
    vec2 g = a-b+c-d;
    vec2 h = p-a;
        
    float k2 = cross2d( g, f );
    float k1 = cross2d( e, f ) + cross2d( h, g );
    float k0 = cross2d( h, e );
    
    // if edges are parallel, this is a linear equation. Do not this test here though, do
    // it in the user code
    if( abs(k2)<0.001 )
    {
        float v = -k0/k1;
        float u  = (h.x*k1+f.x*k0) / (e.x*k1-g.x*k0);
        //if( v>0.0 && v<1.0 && u>0.0 && u<1.0 ) 
            res = vec2( u, v );
    }
	else
    {
        // otherwise, it's a quadratic
        float w = k1*k1 - 4.0*k0*k2;
        //if( w<0.0 ) return vec2(-1.0);
        w = sqrt( w );

        float ik2 = 0.5/k2;
        float v = (-k1 - w)*ik2;// if( v<0.0 || v>1.0 ) v = (-k1 + w)*ik2;
        float u = (h.x - f.x*v)/(e.x + g.x*v);
        //if( u<0.0 || u>1.0 || v<0.0 || v>1.0 ) return vec2(-1.0);
        res = vec2( u, v );
    }
    return (res);
}

float draw(vec2 uv)
{
    return (1.-smoothstep(0., .1, abs(uv.x-.5)))*(1.-smoothstep(0.9, 1., abs(uv.y)+.5));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = (gl_FragCoord.xy)/iResolution.xy;//*2.-1.;
    p.x = p.x*2.-1.;
    p.x *= iResolution.x/iResolution.y;
	p.x = p.x *.5+.5;
    
    vec3 col = vec3(0.);

    const float max_iterations = 16.;
    
    float map = 0.;
    map += draw(p);
    for(float f = 0.; f < max_iterations; f+=1.){
        float iteration = (f/max_iterations+1.);
        float angle = sin(time*iteration)/PI-1.*PI/4.;

        vec2 a = vec2(1., 1.);
        vec2 b = vec2(0., 1.);
        vec2 c = vec2(0., 0.);
        vec2 d = vec2(1., 0.);
        
        p = p*2.-1.;
        
        vec2 s = vec2(.75);
        vec2 o = vec2(.5, 0.);
        mat2 m = rotate(angle);
        
		a = a*2.-1.; b = b*2.-1.; c = c*2.-1.; d = d*2.-1.;
        
        a = a*m; b = b*m; c = c*m; d = d*m;
        a *= s; b *= s; c *= s; d *= s;
        a += o; b += o; c += o; d += o;

        
        /*
        //= a*.5+.5; b = b*.5+.5; c = c*.5+.5; d = d*.5+.5;
		a = a*2.-1.; b = b*2.-1.; c = c*2.-1.; d = d*2.-1.;
		*/

        vec2 a2 = a*vec2(-1., 1.);
        vec2 b2 = b*vec2(-1., 1.);
        vec2 c2 = c*vec2(-1., 1.);
        vec2 d2 = d*vec2(-1., 1.);
        if(p.x > 0.)
        	p = (invBilinear( p, a, b, c, d ));
        else
        	p = (invBilinear( p, a2, b2, c2, d2 ));
            
        map += draw(p);
    }

    gl_FragColor = vec4(flux(map*PI)*clamp(map, 0., 1.), 1.0 );
}